require("mysqloo")
local host = "taken.hosted.nfoservers.com"
local user = "kjhernandez"
local pass = "cuEmpG7CPf"
local db = "kjhernandez_gmpm"
local database = mysqloo.connect(host, user, pass, db, 3306)
database:connect()
database.onConnected = function (db)
    MsgC(Color(255, 0, 255), "Successfully connected to the GMPM database!\n")
end
database.onConnectionFailed = function (db, err)
    MsgC(Color(255, 0, 0), "Failed to connect to the GMPM database. Here's why:\n")
    Error(err .. "\n")
end

local queries = {
    ["Add new Admin"] = "INSERT INTO `admins`(`steamid`, `name`, `rank`) VALUES ('%s','%s','%s')",
    ["Fetch Admin"] = "SELECT `steamid`, `rank` FROM `admins` WHERE `steamid` = '%s'",
    ["Remove Admin"] = "DELETE FROM `admins` WHERE `steamid` = '%s'",
    ["Ban Player"] = "INSERT INTO `bans`(`steamid`, `name`, `reason`, `length`, `admin`, `ip`, `created`, `expires`, `status`) VALUES ('%s','%s','%s','%i','%s','%s','%i','%i','%s')",
    ["Ban Player by SteamID"] = "INSERT INTO `ban`(`steamid`, `name`, `reason`, `length`, `admin`, `created`, `expires`, `status`) VALUES ('%s', '%s', '%s', '%i', '%s', '%i', '%i', '%s')",
    ["Ban Player by IP"] = "INSERT INTO `ban`(`name`, `reason`, `length`, `admin`, `ip`, `created`, `expires`, `status`) VALUES ('%s', '%s', '%i', '%s', '%i', '%i', '%s')",
    ["Ban Player by IP and SteamID"] = "INSERT INTO `ban`(`steamid`, `name`, `reason`, `length`, `admin`, `ip`, `created`, `expire`, `status`) VALUES ('%s','%s','%s','%i','%s','%s','%i','%i','%s')",
    ["Unban Player by SteamID"] = "UPDATE `bans` SET `status`='U',`ureason`='%s', `uadmin`='%s' WHERE steamid = '%s'",
    ["Unban Player by IP"] = "UPDATE `bans` SET `status`='U',`ureason`='%s', `uadmin`='%s' WHERE ip = '%s'",
    ["Fetch Active Bans by SteamID"] = "SELECT `bid`, `steamid`, `name`, `reason`, `length`, `admin`, `ip`, `created`, `expires`, `status`, `ureason`, `uadmin` FROM `bans` WHERE `steamid` = '%s' and `status` = 'A'",
    ["Fetch Active Bans by IP"] = "SELECT `bid`, `steamid`, `name`, `reason`, `length`, `admin`, `ip`, `created`, `expires`, `status`, `ureason` FROM `bans` WHERE ip = '%s' and `status` = 'A'",
}

function gmpm_AddAdmin(Player, rank)
    local query = database:query(queries["Add new Admin"]:format(Player:SteamID(), Player:Nick(), rank))
    query:start()

    query.onSuccess = function(q, data)
        gmpm_notify(Player, "Re-join to get access to admin privileges!", 0, 5)
    end
    query.onError = function(q, err, sql)
        Error(err .. "\n")
    end
end

function gmpm_AddAdminBySteamID(steamid, name, rank)
    local query = database:query(queries["Add new Admin"]:format(steamid, name, rank))
    query:start()

    query.onSuccess = function(q, data)
        for k, v in pairs(player.GetAll()) do
            if v:SteamID() == steamid then
                v:SetUserGroup(rank)
                gmpm_notify(v, "Re-join to get access to admin privileges.", 0, 4)
            end
        end
    end
    query.onError = function(q, err, sql)
        Error(err .. "\n")
    end
end

function gmpm_RemoveAdmin(Player)
    local query = database:query(queries["Remove Admin"]:format(Player:SteamID()))
    query:start()

    query.onSuccess = function(q, data)
        Player:SetUserGroup("user")
        gmpm_notify(Player, "You are no longer a staff member.", 0, 4)
    end
    query.onError = function(q, err, sql)
        Error(err .. "\n")
    end
end

function gmpm_RemoveAdminBySteamID(steamid)
    local query = database:query(queries["Remove Admin"]:format(steamid))
    query:start()

    query.onSuccess = function(q, data)
        for k, v in pairs(player.GetAll()) do
            if v:SteamID() == steamid then
                v:SetUserGroup("user")
            end
        end
    end
    query.onError = function(q, err, sql)
        Error(err .. "\n")
    end
end

function gmpm_GetIP(ply)
    return string.match(ply:IPAddress(), "(%d+%.%d+%.%d+%.%d+)")
end

function gmpm_BanPlayer(Player, reason, length, admin)
    if reason == "" then gmpm_notify(admin, "You must input a reason!", 1, 4) return end
    if !IsValid(Player) then gmpm_notify(admin, "Invalid player!", 1, 4) return end
    if !tonumber(length) then gmpm_notify(admin, "You must enter the ban length as a number!", 1, 4) return end

    local Leng = length*60
    local query = database:query(queries["Ban Player"]:format(Player:SteamID(), Player:Nick(), reason, Leng, admin:Nick(), gmpm_GetIP(Player), os.time(), os.time() + Leng, "A"))
    query:start()

    query.onSuccess = function(q, data)
        Player:Kick("You have been banned!\nAdmin: " .. admin:Nick() .. "\nLength: " .. length .. " minutes\nReason: " .. reason)
        gmpm_notify(Player, "Banned: " .. Player:Nick(), 0, 4)
        gmpm_chatact(Player, " has banned ", Player)
        PrintMessage(3, Player:Nick() .. " was banned for: " .. reason)
    end
    query.onError = function(q, err, sql)
        Error(err .. "\n")
    end
end

function gmpm_BanPlayerBySteamID(steamid, name, reason, length, admin)
    local Leng = length*60
    local query = database:query(queries["Ban Player by SteamID"]:format(steamid, name, reason, Leng, admin:Nick(), os.time(), os.time() + Leng, "A"))
    query:start()

    query.onSuccess = function(q, data)
        for k, v in pairs(player.GetAll()) do
            if v:SteamID() == steamid then
                v:Kick("You have been banned!\nAdmin: " .. admin:Nick() .. "\nLength: " .. length .. " minutes\nReason: " .. reason)
            end
        end
    end
    query.onError = function(q, err, sql)
        Error(err .. "\n")
    end
end

function gmpm_BanPlayerByIP(ip, name, reason, length, admin)
    local Leng = length*60
    local query = database:query(queries["Ban Player by IP"]:format(name, reason, Leng, admin:Nick(), ip, os.time(), os.time() + Leng, "A"))
    query:start()

    query.onSuccess = function(q, data)
        for k, v in pairs(player.GetAll()) do
            if gmpm_GetIP(v) == ip then
                v:Kick("You have been banned!\nAdmin: " .. admin:Nick() .. "\nLength: " .. length .. " minutes\nReason: " .. reason)
            end
        end
    end
    query.onError = function(q, err, sql)
        Error(err .. "\n")
    end
end

function gmpm_BanPlayerBySteamIDandIP(steamid, ip, name, reason, length, admin)
    local Leng = length*60
    local query = database:query(queries["Ban Player by IP and SteamID"]:format(steamid, name, reason, Leng, admin:Nick(), ip, os.time(), os.time() + Leng, "A"))
    query:start()

    query.onSuccess = function(q, data)
        print("success")
    end
    query.onError = function(q, err, sql)
        Error(err .. "\n")
    end
end

function gmpm_UnbanBySteamID(admin, steamid, reason)
    local query = database:query(queries["Unban Player by SteamID"]:format(reason, admin:Nick(), steamid))
    query:start()

    query.onSuccess = function(q, data)
        gmpm_notify(admin, "Successfully unbanned " .. steamid, 0, 4)
    end
    query.onError = function(q, err, sql)
        Error(err .. "\n")
    end
end

function gmpm_UnbanByIP(admin, ip, reason)
    local query = database:query(queries["Unban Player by IP"]:format(reason, admin:Nick(), ip))
    query:start()

    query.onSuccess = function(q, data)
        gmpm_notify(admin, "Successfully unbanned " .. steamid, 0, 4)
    end
    query.onError = function(q, err, sql)
        Error(err .. "\n")
    end
end

function gmpm_CheckActiveBanBySteamID(Player)
    query.onData = function(q, data)
        local steamid64 = util.SteamIDTo64(data.steamid)
        if data != nil then
            Player:Kick("You have been banned!\nAdmin: " .. data.admin .. "\nLength: " .. data.length/60 .. " minutes\nReason: " .. data.reason)
        end
        if steamid64 != Player:OwnerSteamID64() then
            Player:Kick("The account that lent you access to Garry's Mod is currently banned!")
        end
    end
    query.onError = function(q, err, sql)
        Error(err .. "\n")
    end
end

hook.Add("PlayerAuthed", "GMPM - Check for Active Bans by SteamID", function(Player, steamid, uid)
    print("Checking if " .. Player:Nick() .. " has an active ban...\n")
    local query = database:query(queries["Fetch Active Bans by SteamID"]:format(steamid))
    query:start()

    query.onData = function(q, data)
        if data.status == "A" then
            print("Active ban found from " .. Player:Nick() .. "; Kicking\n")
            Player:Kick("You have been banned!\nAdmin: " .. data.admin .. "\nLength: " .. data.length/60 .. " minutes\nReason: " .. data.reason)
        elseif data.status == "E" or data.status == "U" then
            return print("not banned")
        end
    end
    query.onError = function(q, err, sql)
        Error(err .. "\n")
    end
end)

hook.Add("PlayerAuthed", "GMPM - Anti Ban Evasion - Family Share Accounts", function(Player, steamid, uid)
    print("Checking if " .. Player:Nick() .. " is a family shared account where the owner is banned...\n")
    local originsteamid64 = Player:OwnerSteamID64()
    local originsteamid = util.SteamIDFrom64(originsteamid64)
    local query = database:query(queries["Fetch Active Bans by SteamID"]:format(originsteamid))
    query:start()

    query.onData = function(q, data)
        if data != nil then
            print("Family shared account found trying to evade ban; Kicking...\n")
            Player:Kick("The owner of your family shared Garry's Mod copy was banned.")
        end
    end
    query.onError = function(q, err, sql)
        Error(err .. "\n")
    end
end)

hook.Add("PlayerAuthed", "GMPM - Check for Active Bans by IP", function(Player, steamid, uid)
    local ip = string.match(Player:IPAddress(), "(%d+%.%d+%.%d+%.%d+)")
    local query = database:query(queries["Fetch Active Bans by IP"]:format(ip))
    query:start()

    query.onData = function(q, data)
        Player:Kick("You have been banned!\nAdmin: " .. data.admin .. "\nLength: " .. data.length .. " minutes\nReason: " .. data.reason)
    end
    query.onError = function(q, err, sql)
        Error(err .. "\n")
    end
end)

hook.Add("PlayerAuthed", "GMPM - Set Admin Rank", function(Player, steamid, uid)
    local query = database:query(queries["Fetch Admin"]:format(Player:SteamID()))
    query:start()

    query.onData = function(q, data)
        Player:SetUserGroup(data.rank)
    end
    query.onError = function(q, err, sql)
        Error(err .. "\n")
    end
end)