net.Receive("gmpm_reportmenu", function(len)
    local mainframe = vgui.Create("DFrame")
    mainframe:SetTitle("Garry's Mod Player Management Report Menu")
    mainframe:SetSize(800, 500)
    mainframe:Center()
    mainframe:MakePopup()
    mainframe:ShowCloseButton(true)
    mainframe.Paint = function(self, w, h)
        draw.RoundedBox(4, 0, 0, w, h, Color(0, 0, 0, 150))
    end

    local playerList = mainframe:Add("DListView")
    playerList:SetSize(400, 450)
    playerList:Dock(LEFT)
    playerList:AddColumn("Player", 1)
    for k, v in pairs(player.GetAll()) do
        if v:IsPlayer() and !v:IsAdmin() then
            playerList:AddLine(v:Nick())
        end
    end
    playerList.OnRowSelected = function(lst, index, pnl)
        local reported = pnl:GetColumnText(1)

        local writereason = mainframe:Add("DTextEntry")
        writereason:SetSize(390, 300)
        writereason:Dock(BOTTOM)
        writereason.OnEnter = function( self )
            net.Start("gmpm_reportplayer")
                net.WriteString(reported)
                net.WriteString(self:GetValue())
            net.SendToServer()
            mainframe:Close()
        end

        local writereasonlabel1 = mainframe:Add("DLabel")
        writereasonlabel1:SetText("Press enter to submit report!")
        writereasonlabel1:SetFont("CloseCaption_Bold")
        writereasonlabel1:SetTextColor(Color(255, 255, 255))
        writereasonlabel1:Dock(TOP)
        writereasonlabel1:SizeToContents()
    end
end)

net.Receive("gmpm_areportmenu", function(len)
    net.Start("gmpm_fetchreportid")
    net.SendToServer()

    local mainframe = vgui.Create("DFrame")
    mainframe:SetTitle("Garry's Mod Player Management Admin Report Menu")
    mainframe:SetSize(800, 500)
    mainframe:Center()
    mainframe:MakePopup()
    mainframe:ShowCloseButton(true)
    mainframe.Paint = function(self, w, h)
        draw.RoundedBox(8, 0, 0, w, h, Color(0, 0, 0, 150))
    end

    local reportList = vgui.Create("DListView", mainframe)
    reportList:Dock(LEFT)
    reportList:SetMultiSelect(false)
    reportList:AddColumn("ID")
    net.Receive("gmpm_fetchreportid", function(len)
        local id = net.ReadTable()
        reportList:AddLine(id.rid)
    end)
    reportList.OnRowSelected = function(panel, rowIndex, row)
        net.Start("gmpm_fetchreportdata")
            net.WriteInt(row:GetColumnText(1), 32)
        net.SendToServer()

        
        net.Receive("gmpm_fetchreportdata", function(len)
            local report = net.ReadTable()
            local reportpanel = mainframe:Add("DPanel")
            reportpanel:Dock(TOP)
            reportpanel:SetSize(300, 250)

            local reporternamelabel = reportpanel:Add("DLabel")
            reporternamelabel:SetText("Reporter's Name:")
            reporternamelabel:SetPos(10, 10)
            reporternamelabel:SetTextColor(Color(0, 0, 0))
            reporternamelabel:SetFont("CloseCaption_Bold")
            reporternamelabel:SizeToContents()
            local reporternamelabel2 = reportpanel:Add("DLabel")
            reporternamelabel2:SetText(report.reporter)
            reporternamelabel2:SetPos(200, 10)
            reporternamelabel2:SetTextColor(Color(0, 0, 0))
            reporternamelabel2:SetFont("CloseCaption_Bold")
            reporternamelabel2:SizeToContents()

            local reportersteamidlabel = reportpanel:Add("DLabel")
            reportersteamidlabel:SetText("SteamID:")
            reportersteamidlabel:SetPos(10, 50)
            reportersteamidlabel:SetTextColor(Color(0, 0, 0))
            reportersteamidlabel:SetFont("CloseCaption_Bold")
            reportersteamidlabel:SizeToContents()
            local reportersteamidlabel2 = reportpanel:Add("DLabel")
            reportersteamidlabel2:SetText(report.reporterid)
            reportersteamidlabel2:SetPos(120, 50)
            reportersteamidlabel2:SetTextColor(Color(0, 0, 0))
            reportersteamidlabel2:SetFont("CloseCaption_Bold")
            reportersteamidlabel2:SizeToContents()

            local reportednamelabel = reportpanel:Add("DLabel")
            reportednamelabel:SetText("Reported's Name:")
            reportednamelabel:SetPos(10, 90)
            reportednamelabel:SetTextColor(Color(0, 0, 0))
            reportednamelabel:SetFont("CloseCaption_Bold")
            reportednamelabel:SizeToContents()
            local reportednamelabel2 = reportpanel:Add("DLabel")
            reportednamelabel2:SetText(report.reported)
            reportednamelabel2:SetPos(205, 90)
            reportednamelabel2:SetTextColor(Color(0, 0, 0))
            reportednamelabel2:SetFont("CloseCaption_Bold")
            reportednamelabel2:SizeToContents()

            local reportedsteamidlabel = reportpanel:Add("DLabel")
            reportedsteamidlabel:SetText("SteamID:")
            reportedsteamidlabel:SetPos(10, 130)
            reportedsteamidlabel:SetTextColor(Color(0, 0, 0))
            reportedsteamidlabel:SetFont("CloseCaption_Bold")
            reportedsteamidlabel:SizeToContents()
            local reportedsteamidlabel2 = reportpanel:Add("DLabel")
            reportedsteamidlabel2:SetText(report.reportedid)
            reportedsteamidlabel2:SetPos(115, 130)
            reportedsteamidlabel2:SetTextColor(Color(0, 0, 0))
            reportedsteamidlabel2:SetFont("CloseCaption_Bold")
            reportedsteamidlabel2:SizeToContents()

            local reasonlabel = reportpanel:Add("DLabel")
            reasonlabel:SetText("Reason:")
            reasonlabel:SetPos(10, 170)
            reasonlabel:SetTextColor(Color(0, 0, 0))
            reasonlabel:SetFont("CloseCaption_Bold")
            reasonlabel:SizeToContents()
            local reasonlabel2 = reportpanel:Add("DLabel")
            reasonlabel2:SetText(report.reason)
            reasonlabel2:SetPos(100, 170)
            reasonlabel2:SetTextColor(Color(0, 0, 0))
            reasonlabel2:SetFont("CloseCaption_Bold")
            reasonlabel2:SizeToContents()

            local statuslabel = reportpanel:Add("DLabel")
            statuslabel:SetText("Status: ")
            statuslabel:SetPos(10, 210)
            statuslabel:SetTextColor(Color(0, 0, 0))
            statuslabel:SetFont("CloseCaption_Bold")
            statuslabel:SizeToContents()
            local statuslabel2 = reportpanel:Add("DLabel")
            if report.status == "O" then
                statuslabel2:SetText("Open")
            elseif report.status == "I" then
                statuslabel2:SetText("In-Progress")
            end
            statuslabel2:SetPos(95, 210)
            statuslabel2:SetTextColor(Color(0, 0, 0))
            statuslabel2:SetFont("CloseCaption_Bold")
            statuslabel2:SizeToContents()

            local bringreporterbutton = mainframe:Add("DButton")
            bringreporterbutton:SetSize(300, 54)
            bringreporterbutton:SetText("Bring Reporter")
            bringreporterbutton:Dock(TOP)
            bringreporterbutton.Paint = function(self, w, h)
                draw.RoundedBox(0, 0, 0, w, h, Color(0, 0, 0))
                draw.RoundedBox(0, 1, 1, w-2, h-2, Color(0, 255, 0))
            end
            bringreporterbutton.DoClick = function()
                local target = gmpm_FindPlayer(report.reporterid)
                gmpm_gui_Bring(target)
            end

            local bringreportedbutton = mainframe:Add("DButton")
            bringreportedbutton:SetSize(300, 54)
            bringreportedbutton:SetText("Bring Reported")
            bringreportedbutton:Dock(TOP)
            bringreportedbutton.Paint = function(self, w, h)
                draw.RoundedBox(0, 0, 0, w, h, Color(0, 0, 0))
                draw.RoundedBox(0, 1, 1, w-2, h-2, Color(0, 255, 0))
            end
            bringreportedbutton.DoClick = function()
                local target = gmpm_FindPlayer(report.reportedid)
                gmpm_gui_Bring(target)
            end

            local inprogressbutton = mainframe:Add("DButton")
            inprogressbutton:SetSize(300, 54)
            inprogressbutton:SetText("Set report to In-Progress")
            inprogressbutton:Dock(TOP)
            inprogressbutton.Paint = function(self, w, h)
                draw.RoundedBox(0, 0, 0, w, h, Color(0, 0, 0))
                draw.RoundedBox(0, 1, 1, w-2, h-2, Color(0, 255, 0))
            end
            inprogressbutton.DoClick = function()
                net.Start("gmpm_setreportinprogress")
                    net.WriteInt(report.rid, 32)
                net.SendToServer()
            end

            local closedbutton = mainframe:Add("DButton")
            closedbutton:SetSize(300, 54)
            closedbutton:SetText("Set report to Closed")
            closedbutton:Dock(TOP)
            closedbutton.Paint = function(self, w, h)
                draw.RoundedBox(0, 0, 0, w, h, Color(0, 0, 0))
                draw.RoundedBox(0, 1, 1, w-2, h-2, Color(0, 255, 0))
            end
            closedbutton.DoClick = function()
                net.Start("gmpm_setreportclosed")
                    net.WriteInt(report.rid, 32)
                net.SendToServer()
                mainframe:Close()
            end
        end)
    end
end)