local mainContentContainer;
local playerDetailsContainer;

local gmpm_themeColorPrimary = Color(52, 152, 219, 255)
local gmpm_themeColorSecondary = Color(149, 165, 166, 255)
local gmpm_themeColorWhite = Color(255, 255, 255, 255);
local gmpm_themeColorBlack = Color( 0, 0, 0, 255);
local gmpm_themeColorEmerald = Color( 46, 204, 113, 255 )

--Creates a navigation list item for the main menu
local function createNavigationItem(text, width, height, func, lastItem)
	local navigationItem = vgui.Create("DButton")
	navigationItem:SetText(text)
	navigationItem:SetTextColor( Color( 255, 255, 255, 255 ) )
	navigationItem:SetSize(width, height)
	navigationItem:SetFont("Trebuchet24")
	navigationItem.Paint = function(self, w, h)
		draw.RoundedBox( 0, 0, 0, w, h, Color( 41, 128, 185, 250 ))
		draw.RoundedBox( 0, 0, 0, w, 1, gmpm_themeColorBlack)
		if(lastItem) then
			draw.RoundedBox( 0, 0, h-1, w, 1, Color( 0, 0, 0, 255))
		end
	end
	navigationItem.DoClick = func

	return navigationItem;
end

//Create an item within the Player Details Container
local function createPlayerInfoItem(label, content, w, h)
	local playerInfoItem = vgui.Create("DPanel")
	playerInfoItem:SetSize(w, h)

	playerInfoItem.label = vgui.Create("DLabel", playerInfoItem)
	playerInfoItem.label:SetText(label);
	playerInfoItem.label:SetSize(w / 3, h);
	playerInfoItem.label:SetTextColor( Color( 0, 0, 0, 255 ) )
	playerInfoItem.label:SetFont("Trebuchet24")
	playerInfoItem.label:Dock(LEFT)
	playerInfoItem.label:DockMargin(5, 0, 0, 0)

	playerInfoItem.content = vgui.Create("DLabel", playerInfoItem)
	playerInfoItem.content:SetText(content);
	playerInfoItem.content:SetTextColor( Color( 0, 0, 0, 255 ) )
	playerInfoItem.content:SetFont("Trebuchet24")
	playerInfoItem.content:Dock(FILL)
	playerInfoItem.content:DockMargin(0, 0, 0, 0)

	return playerInfoItem
end

local function createCommandListItem(label, w, h, fn)
	local commandListItem = vgui.Create("DButton");
	commandListItem:SetText( label )
	commandListItem:SetTextColor( Color( 255, 255, 255, 255 ) )
	commandListItem:SetSize( w, h )
	commandListItem.Paint = function() 
		draw.RoundedBox( 0, 0, 0, w, h, gmpm_themeColorBlack)
		draw.RoundedBox( 0, 1, 1, w-2, h-2, gmpm_themeColorEmerald)
	end
	commandListItem.DoClick = fn

	return commandListItem;
end

//Populate the Player Details Container with info regarding player and command buttons for player
local function populatePlayerDetailsContainer(Player)
	local width = playerDetailsContainer.ProfileContainer:GetWide();
	local height = 30;
	playerDetailsContainer.TitleLabel:SetText(" " .. Player:Nick() .. "'s Profile Information")
	playerDetailsContainer.profileListItems:Clear()
	playerDetailsContainer.profileListItems:Add(createPlayerInfoItem("Player's Name:", Player:Nick(), width, height))
	playerDetailsContainer.profileListItems:Add(createPlayerInfoItem("Rank:", Player:GetUserGroup() or "", width, height))
	playerDetailsContainer.profileListItems:Add(createPlayerInfoItem("SteamID:", Player:SteamID(), width, height))
	playerDetailsContainer.profileListItems:SizeToContents();

	local heightCommands = 25;
	playerDetailsContainer.commandListItems:Clear();
	playerDetailsContainer.commandListItems:Add(createCommandListItem("Kick", width, heightCommands, 
		function()
			gmpm_gui_Kick(Player)
		end)
	)
	playerDetailsContainer.commandListItems:Add(createCommandListItem("Ban", width, heightCommands, 
		function()
			gmpm_gui_Ban(Player)
		end)
	)
	playerDetailsContainer.commandListItems:Add(createCommandListItem("Warn", width, heightCommands, 
		function()
			gmpm_gui_warnplayer(Player)
		end)
	)
	playerDetailsContainer.commandListItems:Add(createCommandListItem("View Ban History", width, heightCommands, 
		function()
			gmpm_gui_BanHistory(Player)
		end)
	)
	playerDetailsContainer.commandListItems:Add(createCommandListItem("View Warn History", width, heightCommands, 
		function()
			gmpm_gui_getplayerwarns(Player)
		end)
	)
	playerDetailsContainer.commandListItems:Add(createCommandListItem("Team Ban", width, heightCommands, 
		function()
			gmpm_gui_teamban(Player)
		end)
	)
	playerDetailsContainer.commandListItems:Add(createCommandListItem("Respawn", width, heightCommands, 
		function()
			gmpm_gui_Respawn(Player)
		end)
	)
	playerDetailsContainer.commandListItems:Add(createCommandListItem("Toggle Freeze", width, heightCommands, 
		function()
			gmpm_gui_Freeze(Player)
		end)
	)
	playerDetailsContainer.commandListItems:Add(createCommandListItem("Go To", width, heightCommands, 
		function()
			gmpm_gui_Goto(Player)
		end)
	)
	playerDetailsContainer.commandListItems:Add(createCommandListItem("Bring", width, heightCommands, 
		function()
			gmpm_gui_Bring(Player)
		end)
	)
	playerDetailsContainer.commandListItems:Add(createCommandListItem("Change Team", width, heightCommands, 
		function()
			gmpm_gui_ChangeTeam(Player)
		end)
	)
	if LocalPlayer():IsSuperAdmin() then
		playerDetailsContainer.commandListItems:Add(createCommandListItem("Check IP", width, heightCommands,
		function()
			gmpm_gui_getip(Player)
			end)
		)
		if !Player:IsTrialModerator() then
			playerDetailsContainer.commandListItems:Add(createCommandListItem("Add as Staff Member", width, heightCommands,
			function()
				gmpm_gui_AddAdmin(Player)
			end)
			)
		elseif Player:IsTrialModerator() then
			playerDetailsContainer.commandListItems:Add(createCommandListItem("Remove Staff Member", width, heightCommands,
			function()
				gmpm_RemoveAdmin(Player)
			end)
			)
		end
	end

	playerDetailsContainer.commandListItems:SizeToContents();
end

//Create an item within the Player List Container
local function createPlayerItem(Player, width, height)
	local playerItem = vgui.Create("DButton")
	playerItem:SetText(Player:Nick())
	playerItem:SetTextColor( Color( 255, 255, 255, 255 ) )
	playerItem:SetSize(width, height)
	playerItem.Paint = function(self, w, h)
		draw.RoundedBox( 0, 0, 0, w, h, Color( 0, 0, 0, 255 ))
		draw.RoundedBox( 0, 1, 1, w-2, h-2, Color(241, 196, 15, 255))
	end

	playerItem.DoClick = function()
		populatePlayerDetailsContainer(Player);
	end

	return playerItem;
end

local function showPlayerManagement()
	if(mainContentContainer.currentContentContainer != nil) then
		mainContentContainer.currentContentContainer:Remove();
	end

	local width = mainContentContainer:GetWide();
	local height = mainContentContainer:GetTall();

	local playerManagementContainer = vgui.Create("DPanel", mainContentContainer)
	playerManagementContainer:Dock(FILL);

	mainContentContainer.currentContentContainer = playerManagementContainer;

	--Player List
	local playerListContainerWidth = width / 3;
	local playerListContainerLabelHeight = 25;
	local playerListContainerLabel = vgui.Create("DLabel", playerManagementContainer);
	playerListContainerLabel:SetPos(0, 0)
	playerListContainerLabel:SetSize(playerListContainerWidth, playerListContainerLabelHeight);
	playerListContainerLabel:SetText(" Select a Player")
	playerListContainerLabel:SetFont("Trebuchet24")
	playerListContainerLabel:SetTextColor(Color(0, 0, 0, 255))
	playerListContainerLabel.Paint = function(self, w, h)
		draw.RoundedBox( 0, 0, 0, w, h, gmpm_themeColorBlack )
		draw.RoundedBox( 0, 1, 1, w-2, h-2, gmpm_themeColorPrimary)
	end
	local playerListContainer = vgui.Create("DScrollPanel", playerManagementContainer);
	playerListContainer:SetSize( playerListContainerWidth, height - playerListContainerLabelHeight)
	playerListContainer:SetPos( 0, playerListContainerLabelHeight )
	playerListContainer:SetPaintBackground( true )
	playerListContainer:SetBackgroundColor( gmpm_themeColorSecondary )

	local playerList = vgui.Create("DListLayout", playerListContainer);
	playerList:SetSize( playerListContainerWidth, height - playerListContainerLabelHeight)
	playerList:SetPos( 0, 0 )

	for k, v in SortedPairs(player.GetAll()) do
		playerList:Add(createPlayerItem(v, width, 24))
	end
	playerList:SizeToContents()

	--Player Details Container
	local playerDetailsContainerWidth = width - playerListContainerWidth
	playerDetailsContainer = vgui.Create("DPanel", playerManagementContainer);
	playerDetailsContainer:SetPos(playerListContainerWidth, 0);
	playerDetailsContainer:SetSize(playerDetailsContainerWidth, height);
	playerDetailsContainer.Paint = function(self, w, h)
		draw.RoundedBox( 0, 0, 0, w, h, gmpm_themeColorBlack)
		draw.RoundedBox( 0, 1, 1, w-2, h-2, gmpm_themeColorWhite)
	end

		//Profile Info Container
		local titleLabelHeight = playerListContainerLabelHeight;
		playerDetailsContainer.TitleLabel = vgui.Create("DLabel", playerDetailsContainer);
		playerDetailsContainer.TitleLabel:SetPos(0, 0)
		playerDetailsContainer.TitleLabel:SetSize(playerDetailsContainerWidth, titleLabelHeight);
		playerDetailsContainer.TitleLabel:SetText(" Player Information")
		playerDetailsContainer.TitleLabel:SetFont("Trebuchet24")
		playerDetailsContainer.TitleLabel:SetTextColor(Color(0, 0, 0, 255))
		playerDetailsContainer.TitleLabel.Paint = function(self, w, h)
			draw.RoundedBox( 0, 0, 0, w, h, gmpm_themeColorBlack )
			draw.RoundedBox( 0, 1, 1, w-2, h-2, gmpm_themeColorPrimary)
		end

		local profileContainerHeight = (height - (titleLabelHeight*2)) / 2;
		playerDetailsContainer.ProfileContainer = vgui.Create("DScrollPanel", playerDetailsContainer);
		playerDetailsContainer.ProfileContainer:SetPos(0, titleLabelHeight);
		playerDetailsContainer.ProfileContainer:SetSize(playerDetailsContainerWidth, profileContainerHeight);
		playerDetailsContainer.ProfileContainer.Paint = function(self, w, h)
			draw.RoundedBox( 0, 0, 0, w, h, gmpm_themeColorBlack )
			draw.RoundedBox( 0, 1, 0, w-2, h, gmpm_themeColorSecondary )
		end

		playerDetailsContainer.profileListItems = vgui.Create("DListLayout", playerDetailsContainer.ProfileContainer);
		playerDetailsContainer.profileListItems:SetSize( playerDetailsContainerWidth, profileContainerHeight)
		playerDetailsContainer.profileListItems:SetPos( 0, 0 )

		//Commands Sub-Container
		playerDetailsContainer.CommandLabel = vgui.Create("DLabel", playerDetailsContainer);
		playerDetailsContainer.CommandLabel:SetPos(0, profileContainerHeight + titleLabelHeight)
		playerDetailsContainer.CommandLabel:SetSize(playerDetailsContainerWidth, titleLabelHeight);
		playerDetailsContainer.CommandLabel:SetText(" Commands")
		playerDetailsContainer.CommandLabel:SetFont("Trebuchet24")
		playerDetailsContainer.CommandLabel:SetTextColor(Color(0, 0, 0, 255))
		playerDetailsContainer.CommandLabel.Paint = function(self, w, h)
			draw.RoundedBox( 0, 0, 0, w, h, gmpm_themeColorBlack )
			draw.RoundedBox( 0, 1, 1, w-2, h-2, gmpm_themeColorPrimary)
		end

		playerDetailsContainer.CommandContainer = vgui.Create("DScrollPanel", playerDetailsContainer);
		playerDetailsContainer.CommandContainer:SetPos(0, profileContainerHeight + (titleLabelHeight * 2));
		playerDetailsContainer.CommandContainer:SetSize(playerDetailsContainerWidth, profileContainerHeight);
		playerDetailsContainer.CommandContainer.Paint = function(self, w, h)
			draw.RoundedBox( 0, 0, 0, w, h, gmpm_themeColorBlack )
			draw.RoundedBox( 0, 1, 0, w-2, h, gmpm_themeColorSecondary )
		end

		playerDetailsContainer.commandListItems = vgui.Create("DListLayout", playerDetailsContainer.CommandContainer);
		playerDetailsContainer.commandListItems:SetSize( playerDetailsContainerWidth, profileContainerHeight)
		playerDetailsContainer.commandListItems:SetPos( 0, 0 )

end

local function openreports()
	RunConsoleCommand("say", "/report")
end

local function gmpm_gui_CreateMainMenu()
	local mainContainerWidth, mainContainerHeight;

  	local mainContainer = vgui.Create( "DFrame" )
  	mainContainer:SetSize( 800, 500 )
  	mainContainer:SetTitle( "Garry's Mod Player Management Admin Menu" )
  	mainContainer:SetVisible( true )
  	mainContainer:ShowCloseButton( true )
  	mainContainer:SetDraggable( true )
	mainContainer:Center()
  	mainContainer:MakePopup()
  	mainContainer.Paint = function(self, w, h)
		draw.RoundedBox( 8, 0, 0, w, h, Color( 0, 0, 0, 200 ) )
	end

	mainContainerWidth = mainContainer:GetWide()
	mainContainerHeight = mainContainer:GetTall()

	local mainContainerTopOffset = 25;
	local sideBarContainerWidth = 200;
	local sideBarContainerHeight = mainContainerHeight - mainContainerTopOffset;

	--Side Navigation Bar
	local sideBarContainer = vgui.Create("DPanel", mainContainer)
	sideBarContainer:SetPos( 0, mainContainerTopOffset) -- Set the position of the panel
	sideBarContainer:SetSize( sideBarContainerWidth, sideBarContainerHeight ) -- Set the size of the panel

		--Navigation Item Container
		local navigationContainer = vgui.Create( "DListLayout", sideBarContainer )
		navigationContainer:SetSize( sideBarContainerWidth, sideBarContainerHeight)
		navigationContainer:SetPos( 0, 0 )

		navigationContainer:SetPaintBackground( true )
		navigationContainer:SetBackgroundColor( Color( 0, 100, 100 ) )
		navigationContainer:MakeDroppable( "navigationContainerDroppable" ) -- Allows us to rearrange children
		navigationContainer:Add(createNavigationItem("Player Management", sideBarContainerWidth, 45, showPlayerManagement, false))
		navigationContainer:Add(createNavigationItem("Open Reports Menu", sideBarContainerWidth, 45, openreports, false))
	--Main Content Container
	mainContentContainer = vgui.Create("DPanel", mainContainer)
	mainContentContainer:SetPos(sideBarContainerWidth + 5, mainContainerTopOffset)
	mainContentContainer:SetSize(mainContainerWidth - sideBarContainerWidth - 5, sideBarContainerHeight);

	--Show player management by default
	showPlayerManagement();

end

net.Receive("gmpm_AdminMenu", function(length, Player)
	gmpm_gui_CreateMainMenu()
end)