function gmpm_gui_Kick(Player)
    GMPMRequest("Kick " .. Player:Nick(), "Reason for kicking " .. Player:Nick(), "", function(reason)
        net.Start("gmpm_kick")
            net.WriteEntity(Player)
            net.WriteString(reason)
        net.SendToServer()
    end)
end

function gmpm_gui_Ban(Player)
    GMPMRequest("Ban " .. Player:Nick(), "Reason for banning " .. Player:Nick(), "", function(reason)
    GMPMRequest("Length of ban", "How long should " .. Player:Nick() .. " be banned for? (In minutes)", "", function(time)
    net.Start("gmpm_ban")
        net.WriteEntity(Player)
        net.WriteString(reason)
        net.WriteInt(time, 32)
    net.SendToServer()
    end)
    end)
end

function gmpm_gui_teamban(Player)
        local menu = DermaMenu()

        local Padding = vgui.Create("DPanel")
        Padding:SetPaintBackgroundEnabled(false)
        Padding:SetSize(1,5)
        menu:AddPanel(Padding)

        local Title = vgui.Create("DLabel")
        Title:SetText("  Jobs:\n")
        Title:SetFont("UiBold")
        Title:SizeToContents()
        Title:SetTextColor(color_black)
        menu:AddPanel(Title)

        local command = "teamban"
        local uid = Player:UserID()
        for k, v in SortedPairsByMemberValue(RPExtraTeams, "name") do
            local submenu = menu:AddSubMenu(v.name)
            submenu:AddOption("5 minutes",     function() RunConsoleCommand("darkrp", command, uid, k, 300)  end)
            submenu:AddOption("Half an hour",  function() RunConsoleCommand("darkrp", command, uid, k, 1800) end)
            submenu:AddOption("An hour",       function() RunConsoleCommand("darkrp", command, uid, k, 3600) end)
            submenu:AddOption("Until restart", function() RunConsoleCommand("darkrp", command, uid, k, 0)    end)
			submenu:AddOption("Other", function()
				GMPMRequest("Length (In minutes)", "Job ban length for " .. Player:Nick(), "", function(time) RunConsoleCommand("darkrp", command, uid, k, time*60) end) 
			end)
        end
    menu:Open()
end

function gmpm_gui_ChangeTeam(Player)
	local team_menu = DermaMenu() 
	for _, t in SortedPairsByMemberValue(team.GetAllTeams(), "Name") do
		team_menu:AddOption( t.Name, 
			function() 
				net.Start("gmpm_ChangeTeam")
					net.WriteEntity(Player)
					net.WriteUInt(_, 32)
				net.SendToServer()
			end)
	end
	team_menu:AddOption("Close", function() end )
	team_menu:Open()	
end

function gmpm_gui_BanHistory(Player)
    net.Start("gmpm_getbans")
        net.WriteEntity(Player)
    net.SendToServer()
end

function gmpm_gui_getplayerwarns(Player)
    net.Start("gmpm_getplywarns")
        net.WriteEntity(Player)
    net.SendToServer()
end

function gmpm_gui_warnplayer(Player)
    GMPMRequest("Warn Player", "Enter the reason you want to warn " .. Player:Nick(), "", function(reason)
    net.Start("gmpm_warnplayer")
        net.WriteEntity(Player)
        net.WriteString(reason)
    net.SendToServer()
    end)
end

function gmpm_gui_Respawn(Player)
	net.Start("gmpm_RespawnPlayer")
		net.WriteEntity(Player)
	net.SendToServer()
end

function gmpm_gui_Freeze(Player)
	net.Start("gmpm_FreezePlayer")
		net.WriteEntity(Player)
	net.SendToServer()
end

function gmpm_gui_Goto(Player)
	net.Start("gmpm_GotoPlayer")
		net.WriteEntity(Player)
	net.SendToServer()
end

function gmpm_gui_Bring(Player)
	net.Start("gmpm_BringPlayer")
		net.WriteEntity(Player)
	net.SendToServer()
end

function gmpm_gui_Return(Player)
    net.Start("gmpm_ReturnPlayer")
        net.WriteEntity(Player)
    net.SendToServer()
end

function gmpm_gui_MutePlayer(Player)
    net.Start("gmpm_MutePlayer")
        net.WriteEntity(Player)
    net.SendToServer()
end

function gmpm_gui_GagPlayer(Player)
    net.Start("gmpm_GagPlayer")
        net.WriteEntity(Player)
    net.SendToServer()
end

function gmpm_gui_AddAdmin(Player)
    if Player:IsDivisionDirector() then
        local menu = DermaMenu()
        menu:AddOption("Trial Moderator", function()
            net.Start("gmpm_addadmin")
                net.WriteEntity(Player)
                net.WriteString("Trial Moderator")
            net.SendToServer()
        end)
        menu:AddOption("Moderator", function()
            net.Start("gmpm_addadmin")
                net.WriteEntity(Player)
                net.WriteString("Moderator")
            net.SendToServer()
        end)
        menu:AddOption("Senior Moderator", function()
            net.Start("gmpm_addadmin")
                net.WriteEntity(Player)
                net.WriteString("Senior Moderator")
            net.SendToServer()
        end)
        menu:AddOption("Administrator", function()
            net.Start("gmpm_addadmin")
                net.WriteEntity(Player)
                net.WriteString("Administrator")
            net.SendToServer()
        end)
        menu:AddOption("Senior Administrator", function()
            net.Start("gmpm_addadmin")
                net.WriteEntity(Player)
                net.WriteString("Senior Administrator")
            net.SendToServer()
        end)
    elseif Player:IsCommunityManager() then
        menu:AddOption("Division Director", function()
            net.Start("gmpm_addadmin")
                net.WriteEntity(Player)
                net.WriteString("Division Director")
            net.SendToServer()
        end)
    elseif Player:IsOwner() then
        menu:AddOption("Community Manager", function()
            net.Start("gmpm_addadmin")
                net.WriteEntity(Player)
                net.WriteString("Community Manager")
            net.SendToServer()
        end)
        menu:AddOption("admin", function()
            net.Start("gmpm_addadmin")
                net.WriteEntity(Player)
                net.WriteString("admin")
            net.SendToServer()
        end)
        menu:AddOption("superadmin", function()
            net.Start("gmpm_addadmin")
                net.WriteEntity(Player)
                net.WriteString("superadmin")
            net.SendToServer()
        end)
    end
    menu:AddOption("Close", function() end)
    menu:Open()
end

function gmpm_gui_getip(Player)
	net.Start("gmpm_GetIP")
		net.WriteEntity(Player)
	net.SendToServer()

	net.Receive("gmpm_GetIP", function()
		eyepee = net.ReadString()
		LocalPlayer():ChatPrint(eyepee)
	end)
end

local blur = Material("pp/blurscreen")
local function DrawBlur(panel, amount) --Panel blur function
	local x, y = panel:LocalToScreen(0, 0)
	local scrW, scrH = ScrW(), ScrH()
	surface.SetDrawColor(255, 255, 255)
	surface.SetMaterial(blur)
	for i = 1, 6 do
		blur:SetFloat("$blur", (i / 3) * (amount or 6))
		blur:Recompute()
		render.UpdateScreenEffectTexture()
		surface.DrawTexturedRect(x * -1, y * -1, scrW, scrH)
	end
end

function GMPMRequest(strTitle, strText, strDefaultText, fnEnter, fnCancel, strButtonText, strButtonCancelText)
	local Window = vgui.Create("DFrame")
		Window:SetTitle(strTitle or "Message Title (First Parameter)")
		Window:SetDraggable(false)
		Window:ShowCloseButton(false)
		Window:SetBackgroundBlur(true)
		Window:SetDrawOnTop(true)
		Window.Paint = function(self, w, h)
			DrawBlur(self, 3)
			draw.RoundedBox(0, 0, 0, w, h, Color(25, 25, 25, 175))
		end
		
	local InnerPanel = vgui.Create("DPanel", Window)
		InnerPanel:SetDrawBackground(false)
	
	local Text = vgui.Create("DLabel", InnerPanel)
		Text:SetText(strText or "Message Text (Second Parameter)")
		Text:SizeToContents()
		Text:SetContentAlignment(5)
		Text:SetTextColor(color_white)
		
	local TextEntry = vgui.Create("DTextEntry", InnerPanel)
		TextEntry:SetText(strDefaultText or "")
		TextEntry.OnEnter = function() Window:Close() fnEnter(TextEntry:GetValue()) end
		
	local ButtonPanel = vgui.Create("DPanel", Window)
		ButtonPanel:SetTall(30)
		ButtonPanel:SetDrawBackground(false)
		
	local Button = vgui.Create("DButton", ButtonPanel)
		Button:SetText(strButtonText or "OK")
		Button:SizeToContents()
		Button:SetTall(20)
		Button:SetWide(Button:GetWide() + 20)
		Button:SetPos(5, 5)
		Button.DoClick = function() Window:Close() fnEnter(TextEntry:GetValue()) end
		Button.Paint = function(self, w, h) 
			draw.RoundedBox(0, 0, 0, w, h, Color(41, 41, 41, 200)) 
		end
		
	local ButtonCancel = vgui.Create("DButton", ButtonPanel)
		ButtonCancel:SetText(strButtonCancelText or "Cancel")
		ButtonCancel:SizeToContents()
		ButtonCancel:SetTall(20)
		ButtonCancel:SetWide(Button:GetWide() + 20)
		ButtonCancel:SetPos(5, 5)
		ButtonCancel.DoClick = function() Window:Close() if (fnCancel) then fnCancel(TextEntry:GetValue()) end end
		ButtonCancel.Paint = function(self, w, h) 
			draw.RoundedBox(0, 0, 0, w, h, Color(41, 41, 41, 200)) end
		ButtonCancel:MoveRightOf(Button, 5)

	ButtonPanel:SetWide(Button:GetWide() + 5 + ButtonCancel:GetWide() + 10)
	
	local w, h = Text:GetSize()
	w = math.max(w, 400) 
	
	Window:SetSize(w + 50, h + 25 + 75 + 10)
	Window:Center()
	
	InnerPanel:StretchToParent(5, 25, 5, 45)
	
	Text:StretchToParent(5, 5, 5, 35)	
	
	TextEntry:StretchToParent(5, nil, 5, nil)
	TextEntry:AlignBottom(5)
	
	TextEntry:RequestFocus()
	TextEntry:SelectAllText(true)
	
	ButtonPanel:CenterHorizontal()
	ButtonPanel:AlignBottom(8)
	
	Window:MakePopup()
	Window:DoModal()
	return Window
end