function gmpm_ChangeTeam(Player, teamid, admin)
    if admin:IsTrialModerator() then
        if !Player:IsPlayer() then gmpm_notify(admin, "Invalid Player", 1, 4) return end

        if !tonumber(teamid) then gmpm_notify(admin, "Invalid Team!", 1, 4) return end

        Player:changeTeam(teamid, true, true)
        gmpm_notify(admin, "Set Team: " .. Player:Nick(), 0, 4)
        gmpm_chatact(admin, " job changed ", target)
    else
        gmpm_notify(admin, "You are not authorized to perform this action!", 1, 4)
    end
end

function gmpm_RespawnPlayer(Player, admin)
    if admin:IsTrialModerator() then
        if !Player:IsPlayer() and !IsValid(Player) then gmpm_notify(admin, "Not a valid player!", 1, 4) return end
        Player:SetNoDraw(false)
	    Player:SetNotSolid(false)
	    Player:GodDisable()
	    Player:DrawWorldModel(true)
        Player:Spawn()
        gmpm_notify(admin, "Respawned: " .. Player:Nick(), 0, 4)
        gmpm_chatact(admin, " respawned ", Player)
    else
        gmpm_notify(Player, "You are not authorized to perform this action!", 1, 4)
    end
end

function gmpm_FreezePlayer(Player, admin)
    if admin:IsTrialModerator() then
        if !Player:IsPlayer() and !IsValid(Player) then gmpm_notify(admin, "Not a valid player!", 0, 4) return end
        if !Player:IsFrozen() then
            Player:Freeze(true)
            Player:GodEnable()
            gmpm_notify(admin, "Froze: " .. Player:Nick(), 0, 4)
            gmpm_chatact(admin, " froze ", Player)
        else
            Player:Freeze(false)
            Player:GodDisable()
            gmpm_notify(admin, "Unfroze: " .. Player:Nick(), 0, 4)
            gmpm_chatact(admin, " unfroze ", Player)
        end
    else
        gmpm_notify(admin, "You are not authorized to perform this action!", 1, 4)
    end
end

function gmpm_GotoPlayer(Player, admin)
    if admin:IsTrialModerator() then
        if admin:InVehicle() then admin:ExitVehicle() end

        if !admin:IsPlayer() and !IsValid(admin) then gmpm_notify(admin, "Not a valid player!", 0, 4) return end

        Player.gmpm_prevpos = Player:GetPos()
		Player.gmpm_prevang = Player:EyeAngles()

        admin:SetPos( Player:GetPos() + Player:GetForward() * 50 )
        gmpm_notify(admin, "Teleported to: " .. Player:Nick(), 0, 4)
        gmpm_chatact(admin, " teleported to ", Player)
    else
        gmpm_notify(admin, "You are not authorized to perform this action!", 1, 4)
    end
end

function gmpm_BringPlayer(Player, admin)
    if admin:IsTrialModerator() then
        if Player:InVehicle() then Player:ExitVehicle() end

        if !Player:Alive() then gmpm_notify(admin, Player:Nick() .. " is dead!", 1, 4) return end

        if !Player:IsPlayer() and !IsValid(Player) then gmpm_notify(admin, "Not a valid player!", 0, 4) return end

        Player.gmpm_prevpos = Player:GetPos()
		Player.gmpm_prevang = Player:EyeAngles()

        Player:SetPos( admin:GetPos() + admin:GetForward() * 50 )
		gmpm_notify(admin, "Brought: " .. Player:Nick(), 0, 4)
        gmpm_chatact(admin, " brought ", Player)
    else
        gmpm_notify(admin, "You are not authorized to perform this action!", 1, 4)
    end
end

function gmpm_ReturnPlayer(Player, admin)
    if admin:IsTrialModerator() then
        if !Player:Alive() then gmpm_notify(admin, Player:Nick() .. " is dead!", 1, 4) return end

        if !Player:IsPlayer() and !IsValid(Player) then gmpm_notify(admin, "Not a valid player!", 1, 4) return end

        if Player:InVehicle() then Player:ExitVehicle() end

        Player:SetPos(Player.gmpm_prevpos)
        Player:SetEyeAngles(Player.gmpm_prevang)
        Player.gmpm_prevpos = nil
        Player.gmpm_prevang = nil
        Player:SetLocalVelocity( Vector( 0, 0, 0 ) )

        gmpm_chatact(admin, " returned ", Player)
    else
        gmpm_notify(admin, "You are not authorized to perform this action!", 1, 4)
    end
end

function gmpm_GetPlayerIP(Player, admin)
    if admin:IsDivisionDirector() then
        if !Player:IsPlayer() then gmpm_notify(admin, "Not a valid player!", 1, 4) return end

        net.Start("gmpm_GetIP")
            net.WriteString(gmpm_GetIP(Player))
        net.Send(admin)
    else
        gmpm_notify(admin, "You are not authorized to perform this action!", 1, 4)
    end
end

function gmpm_MutePlayer(Player, admin)

end