util.AddNetworkString("gmpm_AdminMenu")
util.AddNetworkString("gmpm_kick")
util.AddNetworkString("gmpm_ban")
util.AddNetworkString("gmpm_ChangeTeam")
util.AddNetworkString("gmpm_RespawnPlayer")
util.AddNetworkString("gmpm_FreezePlayer")
util.AddNetworkString("gmpm_GotoPlayer")
util.AddNetworkString("gmpm_BringPlayer")
util.AddNetworkString("gmpm_GetIP")
util.AddNetworkString("gmpm_addadmin")
-------------------------------------------------------------------
net.Receive("gmpm_kick", function(len, Player)
    if Player:IsTrialModerator() then
        local target = net.ReadEntity()
        local reason = net.ReadString()

        if reason == "" then gmpm_notify(Player, "You must input a reason", 1, 4) return end

        if !IsValid(Player) then gmpm_notify(Player, "Invalid player!", 1, 4) return end

        target:Kick("You were kicked for: " .. reason .. "\nAdmin: " .. Player:Nick())
        gmpm_notify(Player, "Kicked: " .. target:Nick(), 0, 4)
    end
end)

net.Receive("gmpm_ban", function(len, Player)
    if Player:IsTrialModerator() then
        local target = net.ReadEntity()
        local reason = net.ReadString()
        local time = net.ReadInt(32)

        if time == "0" and not Player:IsSeniorModerator() then gmpm_notify(Player, "You must be a higher rank to perma-ban!", 1, 4) return end

        gmpm_BanPlayer(target, reason, time, Player)
    end
end)

net.Receive("gmpm_ChangeTeam", function( len, Player )
    local target = net.ReadEntity()
    local teamid = net.ReadUInt(32)
    gmpm_ChangeTeam(target, teamid, Player)
end)

net.Receive("gmpm_RespawnPlayer", function ( len, Player )
    local target = net.ReadEntity()
    gmpm_RespawnPlayer(target, Player)
end)

net.Receive("gmpm_FreezePlayer", function ( len, Player )
    local target = net.ReadEntity()
    gmpm_FreezePlayer(target, Player)
end)

net.Receive("gmpm_GotoPlayer", function ( len, Player )
    local target = net.ReadEntity()
    gmpm_GotoPlayer(target, Player)
end)

net.Receive("gmpm_BringPlayer", function ( len, Player )
    local target = net.ReadEntity()
    gmpm_BringPlayer(target, Player)
end)

net.Receive("gmpm_ReturnPlayer", function(len, Player)
    local target = net.ReadEntity()
    gmpm_ReturnPlayer(Player, admin)
end)

net.Receive("gmpm_GetIP", function(len, Player)
    local target = net.ReadEntity()
    gmpm_GetPlayerIP(target, Player)
end)

net.Receive("gmpm_addadmin", function(len, Player)
    if Player:IsDivisionDirector() then
        local target = net.ReadEntity()
        local rank = net.ReadString()

        if rank == "" or nil then gmpm_notify(Player, "Invalid rank", 1, 4) return end 

        if target == nil then gmpm_notify(Player, "Invalid Player", 1, 4) return end

        gmpm_AddAdmin(target, rank)
        gmpm_notify(Player, "Successfully gave " .. target:Nick() .. " the rank of " .. rank, 0, 5)
        gmpm_chatact(Player, " added a new staff member: ", target)
    else
        gmpm_notify(Player, "You are not authorized to perform this action!", 1, 4)
    end
end)
--------------------------------------------------------
concommand.Add("gmpm_menu", function(Player, cmd)
    if Player:IsAdmin() then
        net.Start("gmpm_AdminMenu")
        net.Send(Player)
    end
end)