local chatcommands = {};

hook.Add("PlayerSay", "ChatCommandAPI", function (ply, text, teamC)
	local chat_string = string.Explode(" ", text);
	
	for k, v in pairs( chatcommands ) do
		if( chat_string[1] == k ) then
			table.remove(chat_string, 1);
			v(ply, chat_string);
			
			return "";
		end
		
		if( string.find(k, chat_string[1]) != nil ) then
			local start, endp, word = string.find(k, chat_string[1]);
			
			if( endp - (start - 1) > 2 ) then
				ply:ChatPrint("Invalid command! Did you mean '"..tostring( k ).."'?");
				
				return "";
			end
		end
	end
	
	return text;
end)

function RegisterChatCommand(strCommand, Func)
	if( !strCommand || !Func ) then return; end
	
	for k, v in pairs( chatcommands ) do
		if( strCommand == k ) then
			return;
		end
	end
	
	chatcommands[ tostring( strCommand ) ] = Func;
end
----------------------------------------------------------------------------
RegisterChatCommand("/goto", function(ply, args)
	if ply:IsTrialModerator() then
		local target = gmpm_FindPlayer(args[1])

		if target == nil then
			gmpm_notify(ply, "No target!", 1, 4) 
		return end

		if ply:InVehicle() then
			ply:ExitVehicle()
		end

		ply:SetPos( target:GetPos() + target:GetForward() * 50 )
		gmpm_notify(ply, "Teleported to: " .. target:Nick(), 0, 4)
		gmpm_chatact(ply, " teleported to ", target)
	end
end)

RegisterChatCommand("/bring", function(ply, args)
	if ply:IsTrialModerator() then
		local target = gmpm_FindPlayer(args[1])

		if target == nil then
			gmpm_notify(ply, "No target!", 1, 4) 
		return end

		if target:InVehicle() then
			target:ExitVehicle()
		end

		if !target:Alive() then
			gmpm_notify(ply, target:Nick() .. " is dead!", 1, 4)
		return end

		lastlocation = target:GetPos()
		target:SetPos( ply:GetPos() + ply:GetForward() * 50 )
		gmpm_notify(ply, "Brought: " .. target:Nick(), 0, 4)
		gmpm_chatact(ply, " brought ", target)
	end
end)

RegisterChatCommand("/fbring", function(ply, args)
	if ply:IsTrialModerator() then
		local target = gmpm_FindPlayer(args[1])

		if target == nil then
			gmpm_notify(ply, "No target!", 1, 4) 
		return end

		if target:InVehicle() then
			target:ExitVehicle()
		end

		if !target:Alive() then
			gmpm_notify(ply, target:Nick() .. " is dead!", 1, 4)
		return end

		target:SetPos( ply:GetPos() + ply:GetForward() * 50 )
		target:Freeze(true)
		gmpm_notify(ply, "Brought: " .. target:Nick(), 0, 4)
		gmpm_chatact(ply, " froze and brought ", target)
	end
end)

RegisterChatCommand("/return", function(ply, args)
	if ply:IsTrialModerator() then
		local target = gmpm_FindPlayer(args[1])
		gmpm_ReturnPlayer(target, ply)
	end
end)

RegisterChatCommand("/freeze", function(ply, args)
	if ply:IsTrialModerator() then
		local target = gmpm_FindPlayer(args[1])

		if target == nil then
			gmpm_notify(ply, "No target!", 1, 4) 
		return end

		if !target:Alive() then
			gmpm_notify(ply, target:Nick() .. " is dead!", 1, 4)
		return end

		target:Freeze(true)
		gmpm_notify(ply, "Froze: " .. target:Nick(), 0, 4)
		gmpm_chatact(ply, " froze ", target)
	end
end)

RegisterChatCommand("/unfreeze", function(ply, args)
	if ply:IsTrialModerator() then
		local target = gmpm_FindPlayer(args[1])

		if target == nil then
			ply:ChatPrint("No target!") 
		return end

		target:Freeze(false)
		gmpm_notify(ply, "Unfroze: " .. target:Nick(), 0, 4)
		gmpm_chatact(ply, " unfroze ", target)
	end
end)

RegisterChatCommand("/respawn", function(ply, args)
	if ply:IsTrialModerator() then
		local target = gmpm_FindPlayer(args[1])

		if target:InVehicle() then return end

		if target == nil then
			ply:Spawn()
			ply:SetNoDraw(false)
			ply:SetNotSolid(false)
			ply:GodDisable()
			ply:DrawWorldModel(true)
			gmpm_notify(ply, "Respawned: " .. ply:Nick(), 0, 4)
			gmpm_chatact(ply, " respawned ", ply)
		return end

		target:Spawn()
		target:SetNoDraw(false)
		target:SetNotSolid(false)
		target:GodDisable()
		target:DrawWorldModel(true)
		gmpm_notify(ply, "Respawned: " .. target:Nick(), 0, 4)
		gmpm_chatact(ply, " respawned ", target)
	end
end)

RegisterChatCommand("/hp", function(ply, args)
	if ply:IsSuperAdmin() then
		local target = gmpm_FindPlayer(args[1])

		if target == nil then gmpm_notify(ply, "Invalid target!", 1, 4) return end

		target:SetHealth(args[2])
	end
end)


util.AddNetworkString("gmpm_areportmenu")
util.AddNetworkString("gmpm_reportmenu")
--[[RegisterChatCommand("/areport", function(ply, args)
    if ply:IsTrialModerator() then
        net.Start("gmpm_areportmenu")
        net.Send(ply)
	end
end)]]--
RegisterChatCommand("/report", function(ply, args)
	if ply:IsTrialModerator() then
        net.Start("gmpm_areportmenu")
        net.Send(ply)
	else
    	net.Start("gmpm_reportmenu")
    	net.Send(ply)
	end
end)